#ifndef _PIXELLINE_H_
#define _PIXELLINE_H_

#include <QD_Types.h>

class TFormatData;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                            TPixelLine
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TPixelLine
{
public: // Types

  enum TComponent
  {
    RED,
    GREEN,
    BLUE
  };

  enum TOperation
  {
    ADD,
    SUBTRACT,
    MULTIPLY
  };

public: // Methods

  //*** Default Constructor
  TPixelLine();

  //*** Destructor
  ~TPixelLine();

  //*** Setup to match the specified format
  bool Init( const TFormatData& fmt );

  INT32   GetLineActive();
  INT32   GetLineTotal();
  double  GetLineRate();
  double* GetComponent( TComponent comp );

  //*** Zero the entire line
  void ZeroAll();

  //--------------------------------------------------------
  // Rendering Methods
  //--------------------------------------------------------

  //*** Select the arithmatic operation
  void SetComponent( TComponent comp );
  void SetOperation( TOperation op   );

  bool UnitSinSquareBar( INT32 riseSamples, INT32 start, INT32 end );
  bool SinSquareBar    ( INT32 riseSamples, INT32 start, INT32 end, double level );
  bool SinSquareStep   ( INT32 riseSamples, INT32 start, double level );
  bool SwpSin          ( double startFreq, double endFreq, INT32 start, INT32 end, double phaseDeg, double level );
  bool Ramp            ( INT32 start, INT32 end, double level );
  bool SinX            ( double freq, INT32 phaseX, double phaseDeg, double level );
  bool SinX_X          ( double peakLevel, double stopFreq, INT32 peakX );
  bool SinSquarePulse  ( INT32 had, INT32 peakX, double peakLevel );
  bool SinXBurst       ( double freq, INT32 phaseX, double phaseDeg, double peakLevel, INT32 start, INT32 end, INT32 riseSamples );
  bool MultiPulse      ( double freq, INT32 peakX, INT32 had, double peakLevel );
  bool Factor          ( double factor );

  //*** Copy the current selected component to the specified component
  bool CopyTo( TComponent comp );

private: // Methods

  void DeleteLine();

private: // Data

  INT32      m_lineActive;
  INT32      m_lineTotal;
  double     m_lineRate;
  TOperation m_op;
  TComponent m_comp;
  double     m_vpp;
  double     m_prate;

  double* m_red;
  double* m_green;
  double* m_blue;
};


#endif // _PIXELLINE_H_

